	% Ex 14.26
	close all, clear all, clc
	
	N = 9;             			% Filter order (odd)
	Nd = 6;          		% Number of delay cases
	d = (0:Nd-1)*0.1; 		% Incremental delay cases
	wT = linspace(0, pi, 1000);
	for m = 1: Nd			% Design the Lagrange filters
		D = floor(N/2) + d(m);	% Integer delay + d
		h = ones(1, N+1);
		for n = 0:N      		% Lagrange polynomials    
			for k = 0:N
				if (k ~= n), 
					h(n+1) = h(n+1)*(D-k)/(n-k);
				end
			end
		end	
		hL(m,:) = h/sum(h);		% Scale the response to |H(1)| = 1
		HL(m,:) = freqz(hL(m,:),1,1000)';	% The frequency responses for case m
		uwrapphase = -unwrap(angle(HL(m,:)));
		wT(1) = 1; 				% Avoid to dividing by zero
		phasedelay(m,:) = -uwrapphase./wT; phasedelay(m,1) = phasedelay(m,2);
	end	 
	wT(1) = 0; 
	PLOT_FD_RESPONSE(wT, HL, phasedelay, Nd, d, floor(N/2))		
	
